import argparse

def get_args():
    parser = argparse.ArgumentParser(description='Arguments for RL_GNN_JSP')
    # args for normal setting
    parser.add_argument('--device', type=str, default='cuda')
    # args for env
    parser.add_argument('--instance_type', type=str, default='FJSP')
    parser.add_argument('--data_size', type=int, default=10)
    parser.add_argument('--max_process_time', type=int, default=100, help='Maximum Process Time of an Operation')
    parser.add_argument('--delete_node', type=bool, default=False, help='+op')
    # args for RL
    parser.add_argument('--entropy_coef', type=float, default=1e-2)
    parser.add_argument('--episode', type=int, default=1000001)
    parser.add_argument('--lr', type=float, default=1e-4)
    parser.add_argument('--step_size', type=float, default=1000)
    # args for policy network
    parser.add_argument('--hidden_dim', type=int, default=256) 
    # args for GNN
    parser.add_argument('--GNN_num_layers', type=int, default=3)
    # args for policy
    parser.add_argument('--policy_num_layers', type=int, default=2)
    # args for name
    parser.add_argument('--date', type=str, default='Dummy')
    parser.add_argument('--detail', type=str, default=None)

    # for evaluation
    parser.add_argument('--test_dir', type=str, default='./datasets/FJSP/Brandimarte_Data')
    parser.add_argument('--valid_dir', type=str, default='./datasets/FJSP/Song_Data/data_dev/1510')
    parser.add_argument('--load_weight', type=str, default='./weight/RS_FJSP/best')


    args = parser.parse_args()
    return args
